var jsyaml = require('./js-yaml.min');

var LENGTH = 30;

function check(yaml, character) {
  var i = yaml.indexOf(character);
  
  if (i >= 0) {
    var pre = yaml.substring(i - LENGTH, i),
        post = yaml.substring(i + 1, i + LENGTH);
    
    throw 'Ungültiges Zeichen ("' + character + '" - Code: ' + character.charCodeAt(0) + ') in Eingabedatei an Stelle: ' + i + ' - "...' + pre + '<' + character + '>' + post + '..."';
  }
}

exports.load = function(yaml) {
  check(yaml, '\u00A0');
  return jsyaml.load(yaml);
};

exports.loadAll = function(yaml, callback) {
  check(yaml, '\u00A0');
  return jsyaml.loadAll(yaml, callback);
};

exports.dump = jsyaml.dump;